# 相册模块重构说明

## 文件结构

### 新的组织结构
```
Views/Photo/
├── PhotoView.swift                    # 主要相册视图和UI组件
├── BasePhotoServiceView.swift         # 基础相册服务类和工厂模式
├── TencentPhotoServiceView.swift      # 腾讯云相册服务
├── AliyunPhotoServiceView.swift       # 阿里云相册服务
├── QiniuPhotoServiceView.swift        # 七牛云相册服务
├── BaiduPhotoServiceView.swift        # 百度云相册服务
├── HuaweiPhotoServiceView.swift       # 华为云相册服务
├── UpyunPhotoServiceView.swift        # 又拍云相册服务
├── S3PhotoServiceView.swift           # S3相册服务
├── GitHubPhotoServiceView.swift       # GitHub相册服务
└── PhotoViewUtils.swift               # 通用工具函数和模型
```

## 重构内容

### 1. 模块化设计
- **BasePhotoServiceView.swift**: 包含基础相册服务类和工厂模式，为添加新的云服务提供统一接口
- **云服务特定文件**: 每个云服务都有独立的文件，包含特定的API调用逻辑和响应模型
- **PhotoViewUtils.swift**: 包含通用的工具函数、模型定义和扩展

### 2. 工厂模式
使用 `PhotoServiceFactory` 来根据云服务名称创建对应的服务实例：
```swift
PhotoServiceFactory.createPhotoService(for: serviceName)
```

### 3. 各云服务职责分离

#### TencentPhotoServiceView.swift
- 腾讯云COS API调用
- XML响应解析
- 腾讯云特定的签名算法

#### AliyunPhotoServiceView.swift
- 阿里云OSS API调用
- JSON响应解析
- 阿里云特定的认证逻辑

#### QiniuPhotoServiceView.swift
- 七牛云API调用（目前为模拟数据）
- 可扩展为真实的七牛云API

#### BaiduPhotoServiceView.swift
- 百度云BOS API调用
- JSON响应解析
- 百度云特定的BCE认证算法

#### HuaweiPhotoServiceView.swift
- 华为云OBS API调用
- 响应数据处理

#### UpyunPhotoServiceView.swift
- 又拍云USS API调用
- 又拍云特定的认证逻辑

#### S3PhotoServiceView.swift
- S3 API调用
- S3兼容服务支持

#### GitHubPhotoServiceView.swift
- GitHub Contents API调用
- 支持列出指定目录下的所有文件
- 支持自定义域名显示
- GitHub特定的认证和错误处理

### 4. 通用组件保留在主文件
- PhotoView: 主要UI组件
- PhotoGridView: 网格视图
- PhotoListView: 列表视图
- PhotoThumbnailView: 缩略图组件
- PhotoContextMenu: 上下文菜单

## 优势

### 1. 可扩展性
- 添加新的云服务只需要创建一个新的服务文件，继承 `BasePhotoService`
- 不需要修改现有代码

### 2. 维护性
- 每个云服务的代码独立，便于维护和调试
- 职责分离清晰，修改某个云服务不影响其他服务

### 3. 代码复用
- 通用功能在 `PhotoViewUtils.swift` 中统一管理
- 基础服务逻辑在 `BasePhotoService` 中复用

## 如何添加新的云服务

1. 创建新的服务文件，例如 `NewCloudPhotoServiceView.swift`
2. 继承 `BasePhotoService` 类
3. 实现 `fetchPhotos` 方法
4. 在 `PhotoServiceFactory` 中添加新的case
5. 定义特定的响应模型（如果需要）

示例：
```swift
// NewCloudPhotoServiceView.swift
class NewCloudPhotoService: BasePhotoService {
    override func fetchPhotos(from cloudService: CloudStorageService) -> AnyPublisher<[PhotoItem], NetworkError> {
        // 实现新云服务的API调用逻辑
    }
}

// 在 PhotoServiceFactory 中添加
case "GitHub":
    return GitHubPhotoService()
case "新云服务":
    return NewCloudPhotoService()
```

## 注意事项

1. 所有云服务相关的API密钥和敏感信息应该从配置中获取，不要硬编码
2. 错误处理应该统一，使用 `NetworkError` 类型
3. 日志输出应该包含足够的调试信息
4. 新增云服务时请确保遵循现有的代码风格和架构模式
